package org.msh.tb.export_rest.core;

import java.util.ArrayList;
import java.util.List;

/**
 * Group records with the same continuous key in the same row
 * Created by rmemoria on 19/7/17.
 */
public class GroupedBlockReader extends BlockReaderImpl {

    private BlockReader reader;
    private int maxGroupedRecords;

    /**
     * Default constructor
     *
     * @param reader            the reader to get records from
     * @param maxGroupedRecords the max number of grouped records
     */
    public GroupedBlockReader(BlockReader reader, int maxGroupedRecords) {
        this.reader = reader;
        this.maxGroupedRecords = maxGroupedRecords;
    }

    @Override
    public List<String> getColumns() {
        List<String> readerCols = reader.getColumns();

        List<String> cols = new ArrayList<String>(maxGroupedRecords * readerCols.size());
        for (int i = 1; i <= maxGroupedRecords; i++) {
            for (String title : readerCols) {
                cols.add(Integer.toString(i) + " - " + title);
            }
        }
        return cols;
    }

    @Override
    protected Record readNext() {
        Record rec = reader.current();
        if (reader.current() == null) {
            return null;
        }

        Object key = rec.getKey();
        List<Object> groupedVals = new ArrayList();

        while (rec != null && key.equals(rec.getKey())) {
            List<Object> vals = rec.getValues();
            groupedVals.addAll(vals);

            rec = reader.next();
        }

        Record grpRecord = new Record(key, groupedVals);

        return grpRecord;
    }

    public BlockReader getReader() {
        return reader;
    }

    public void setReader(BlockReader reader) {
        this.reader = reader;
    }

    public int getMaxGroupedRecords() {
        return maxGroupedRecords;
    }

    public void setMaxGroupedRecords(int maxGroupedRecords) {
        this.maxGroupedRecords = maxGroupedRecords;
    }
}
